import matplotlib.pyplot as plt
import matplotlib.patches as patches

# Create a figure and axis
fig, ax = plt.subplots(figsize=(8, 10))

# Define tile colors
clear_color = "green"
not_clear_color = "red"

# Define robot colors
robot1_color = "white"
robot2_color = "black"

# Define available colors
available_colors = {"white": "white", "black": "black"}

# Draw tiles
for row in range(5):
    for col in range(4):
        tile_id = f"tile_{row}-{col+1}"
        if (row == 1 and col == 0) or (row == 1 and col == 1):
            # Tiles occupied by robots
            tile_color = not_clear_color
        else:
            # Clear tiles
            tile_color = clear_color
        
        # Create tile rectangle
        rect = patches.Rectangle((col, 4-row), 1, 1, linewidth=1, edgecolor='black', facecolor=tile_color)
        ax.add_patch(rect)
        # Add tile label
        ax.text(col + 0.5, 4 - row + 0.5, tile_id, ha='center', va='center', fontsize=8, color='black')

# Draw robots
robot_positions = {'robot1': (0, 3), 'robot2': (1, 3)}
robot_colors = {'robot1': robot1_color, 'robot2': robot2_color}

for robot, (col, row) in robot_positions.items():
    circ = patches.Circle((col + 0.5, row + 0.5), 0.25, color=robot_colors[robot], ec='black')
    ax.add_patch(circ)
    # Add robot label
    ax.text(col + 0.5, row + 0.5, f"{robot}\n{robot_colors[robot]}", ha='center', va='center', fontsize=8, color='black')

# Draw available colors
for i, (color_name, color_hex) in enumerate(available_colors.items()):
    rect = patches.Rectangle((5, 4 - i), 0.5, 0.5, linewidth=1, edgecolor='black', facecolor=color_hex)
    ax.add_patch(rect)
    # Add color label
    ax.text(5.25, 4 - i + 0.25, color_name, ha='left', va='center', fontsize=8, color='black')

# Create legend
legend_elements = [
    patches.Patch(facecolor=clear_color, edgecolor='black', label='Clear Tile'),
    patches.Patch(facecolor=not_clear_color, edgecolor='black', label='Not Clear Tile'),
]
ax.legend(handles=legend_elements, loc='upper right')

# Set limits and remove axes
ax.set_xlim(0, 6)
ax.set_ylim(0, 5)
ax.set_xticks([])
ax.set_yticks([])
ax.set_aspect('equal')

# Save the figure
plt.savefig("tiles/one_shot/ini_diagram_code/attempts/attempt_5.png", bbox_inches='tight')
plt.show()
# VERIFICATION FAILED:
# Legend overlaps with the grid, making it unclear.
